import java.net.MalformedURLException;
import java.io.IOException;
import java.io.DataInputStream;
import java.net.URL;
import java.awt.Polygon;
import java.awt.image.ImageObserver;
import java.awt.Component;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Event;
import java.awt.MediaTracker;
import java.awt.TextField;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.applet.Applet;

//
// Decompiled by Procyon v0.5.36
//

public class Fillit extends Applet implements Runnable
{
    Thread MyThread;
    static final int FPS = 30;
    static final int DELAY = 33;
    static final int MAX_STAGES = 10;
    static final int MIN_PERCENT = 80;
    static final int GAME_ACTIVE = 0;
    static final int INTRO_ACTIVE = 1;
    static final int MAX_SPRITES = 32;
    static final int MAX_PRIORITY = 3;
    static final int X_OFFSET = 0;
    static final int Y_OFFSET = 16;
    static int[] SinusList;
    static int GameFlag;
    static int KeyDownCode;
    static int KeyUpCode;
    static boolean Key_L;
    static boolean Key_R;
    static boolean Key_U;
    static boolean Key_D;
    static int OverCounter;
    static int CompleteCounter;
    static boolean GameOver;
    static boolean LevelComplete;
    static boolean GameComplete;
    static long Filled;
    static long HiScore;
    static long Score;
    static long Lives;
    static long Stage;
    static long Percent;
    static long oldscore;
    static Image BackBuffer;
    static Graphics MyGfx;
    static Image RescueBuffer;
    static Graphics RescueGfx;
    static Dimension dim;
    static Image Title;
    static Image[] Player_Frames;
    static Image[] Enemy_Frames;
    Button again;
    Button send;
    TextField entryName;
    CGIcall cgi;
    boolean alreadysent;
    boolean gameover;
    boolean goleft;
    boolean goright;
    private final String param_cfg_file = "Scorepath";
    private String m_cfgfile;
    private String param;
    private String URLName;
    MediaTracker m_mediaTracker;
    static Sprite[] Bobs;
    static int xsize;
    static int ysize;
    static byte[][] Matrix;
    static boolean updated;

    public boolean keyDown(final Event event, final int keyDownCode) {
        if (this.gameover) {
            return false;
        }
        switch (Fillit.KeyDownCode = keyDownCode) {
            case 1006: {
                Fillit.Key_L = true;
                break;
            }
            case 1007: {
                Fillit.Key_R = true;
                break;
            }
            case 1004: {
                Fillit.Key_U = true;
                break;
            }
            case 1005: {
                Fillit.Key_D = true;
                break;
            }
        }
        return true;
    }

    public void stop() {
        if (this.MyThread != null) {
            this.MyThread.stop();
            this.MyThread = null;
        }
    }

    private void GameHandler() {
        if (!Fillit.LevelComplete && !Fillit.GameComplete) {
            if (Fillit.Percent >= 80L) {
                Fillit.LevelComplete = true;
                Fillit.CompleteCounter = 100;
            }
        }
        else if (Fillit.CompleteCounter-- <= 0) {
            if (Fillit.Stage++ < 10L) {
                this.InitStage();
            }
            else if (!Fillit.GameComplete) {
                Fillit.GameComplete = true;
            }
        }
        int n = 0;
        do {
            if (Fillit.Bobs[n] != null && !Fillit.Bobs[n].Handler()) {
                Fillit.Bobs[n] = null;
            }
        } while (++n < 32);
        this.repaint();
    }

    private void InitSprites() {
        this.GetNewSprite((Sprite)new Player(Fillit.xsize / 2, Fillit.ysize - 1, 0, 16, Fillit.xsize, Fillit.ysize));
        switch ((int)Fillit.Stage) {
            case 1: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 2: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 3: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 4: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 5: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 6: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 7: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 8: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 9: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            case 10: {
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                this.GetNewSprite((Sprite)new Enemy(1, 1, 0, 16, Fillit.xsize, Fillit.ysize));
                break;
            }
            default: {}
        }
    }

    public void InitStage() {
        Fillit.KeyUpCode = 0;
        Fillit.KeyDownCode = 0;
        Fillit.Key_L = false;
        Fillit.Key_R = false;
        Fillit.CompleteCounter = 0;
        Fillit.LevelComplete = false;
        Fillit.Filled = 0L;
        int n = 0;
        do {
            Fillit.Bobs[n] = null;
        } while (++n < 32);
        this.InitSprites();
        Fillit.Matrix = new byte[Fillit.xsize][Fillit.ysize];
        for (int i = 0; i < Fillit.xsize; ++i) {
            for (int j = 0; j < Fillit.ysize; ++j) {
                Fillit.Matrix[i][j] = 0;
            }
        }
        for (int k = 0; k < Fillit.xsize; ++k) {
            Fillit.Matrix[k][0] = 2;
            Fillit.Matrix[k][Fillit.ysize - 1] = 2;
        }
        for (int l = 0; l < Fillit.ysize; ++l) {
            Fillit.Matrix[0][l] = 2;
            Fillit.Matrix[Fillit.xsize - 1][l] = 2;
        }
        Fillit.MyGfx.setColor(Color.black);
        Fillit.MyGfx.fillRect(0, 0, Fillit.dim.width, Fillit.dim.height);
        Fillit.MyGfx.setColor(Player.COL_LINE);
        Fillit.MyGfx.drawRect(0, 16, Fillit.xsize - 1, Fillit.ysize - 1);
        Fillit.RescueGfx.setColor(Color.black);
        Fillit.RescueGfx.fillRect(0, 0, Fillit.dim.width, Fillit.dim.height);
        Fillit.RescueGfx.setColor(Player.COL_LINE);
        Fillit.RescueGfx.drawRect(0, 16, Fillit.xsize - 1, Fillit.ysize - 1);
        Fillit.updated = false;
        this.repaint();
    }

    private AudioClip LoadAudioClip(final String name) {
        final AudioClip audioClip = this.getAudioClip(this.getDocumentBase(), name);
        audioClip.play();
        audioClip.stop();
        return audioClip;
    }

    public Fillit() {
        this.MyThread = null;
        this.m_cfgfile = "";
        this.param = "";
        this.m_mediaTracker = new MediaTracker(this);
    }

    public void paint(final Graphics graphics) {
        if (this.m_mediaTracker.checkAll()) {
            if (this.m_mediaTracker.isErrorAny()) {
                graphics.drawString("Error loading images", 10, 40);
                return;
            }
            if (Fillit.BackBuffer != null) {
                graphics.drawImage(Fillit.BackBuffer, 0, 0, null);
            }
        }
        else {
            graphics.drawString("Loading data, please wait...", 10, 20);
        }
    }

    public static boolean EnemyInside(final Polygon polygon) {
        int n = 0;
        while (Fillit.Bobs[n] == null || !Fillit.Bobs[n].Name.equals("Enemy") || !polygon.inside(Fillit.Bobs[n].XPos, Fillit.Bobs[n].YPos)) {
            if (++n >= 32) {
                return false;
            }
        }
        return true;
    }

    public void destroy() {
    }

    public void InitGame() {
        Fillit.OverCounter = 0;
        Fillit.GameOver = false;
        Fillit.Score = 0L;
        Fillit.Lives = 3L;
        Fillit.Stage = 1L;
        Fillit.Percent = 0L;
        Fillit.GameComplete = false;
        Fillit.GameFlag = 0;
        this.InitStage();
    }

    private void PaintGame(final Graphics graphics) {
        graphics.drawImage(Fillit.RescueBuffer, 0, 0, null);
        int n = 0;
        do {
            int n2 = 0;
            do {
                if (Fillit.Bobs[n2] != null && Fillit.Bobs[n2].Visible && Fillit.Bobs[n2].Priority == n) {
                    Fillit.Bobs[n2].Copy(graphics);
                }
            } while (++n2 < 32);
        } while (++n < 3);
        Fillit.Percent = (long)(Fillit.Filled / (double)(Fillit.xsize * Fillit.ysize) * 100.0);
        if (Fillit.Score > Fillit.HiScore) {
            Fillit.HiScore = Fillit.Score;
        }
        graphics.setColor(Color.green);
        graphics.drawString("Hi : " + Fillit.HiScore, 26, 11);
        graphics.drawString("Score : " + Fillit.Score, 98, 11);
        graphics.drawString("Lives : " + Fillit.Lives, 198, 11);
        graphics.drawString("% : " + Fillit.Percent, 276, 11);
        graphics.drawString("Stage : " + Fillit.Stage, 326, 11);
        if (Fillit.GameComplete) {
            graphics.setColor(Color.black);
            graphics.drawString("Game completed!", Fillit.dim.width / 2 - 32 + 1, Fillit.dim.height / 2 - 24 + 1);
            graphics.setColor(Color.white);
            graphics.drawString("Game completed!", Fillit.dim.width / 2 - 32, Fillit.dim.height / 2 - 24);
            Fillit.OverCounter = 200;
        }
        else if (Fillit.LevelComplete) {
            graphics.setColor(Color.black);
            graphics.drawString("Stage completed!", Fillit.dim.width / 2 - 32 + 1, Fillit.dim.height / 2 - 4 + 1);
            graphics.setColor(Color.white);
            graphics.drawString("Stage completed!", Fillit.dim.width / 2 - 32, Fillit.dim.height / 2 - 4);
        }
        if (Fillit.OverCounter > 0) {
            graphics.setColor(Color.black);
            graphics.drawString("Game Over", Fillit.dim.width / 2 - 24 - 1, Fillit.dim.height / 2 - 4 - 1);
            graphics.drawString("Game Over", Fillit.dim.width / 2 - 24 + 1, Fillit.dim.height / 2 - 4 + 1);
            graphics.setColor(Color.red);
            graphics.drawString("Game Over", Fillit.dim.width / 2 - 24, Fillit.dim.height / 2 - 4);
            if (!this.alreadysent) {
                this.again.show();
                if (!this.gameover) {
                    this.entryName.requestFocus();
                }
                Fillit.oldscore = Fillit.Score;
                this.gameover = true;
                if (Fillit.Score >= 10000L) {
                    graphics.setColor(Color.black);
                    graphics.drawString("High Score List", 221, 186);
                    graphics.drawString("Enter your name", 221, 201);
                    graphics.drawString("High Score List", 219, 184);
                    graphics.drawString("Enter your name", 219, 199);
                    graphics.setColor(Color.white);
                    graphics.drawString("High Score List", 220, 185);
                    graphics.drawString("Enter your name", 220, 200);
                    this.send.show();
                    this.entryName.show();
                    if (this.entryName.getText().equals("")) {
                        this.send.disable();
                        return;
                    }
                    this.send.enable();
                }
            }
        }
    }

    private Image LoadImage(final String name) {
        final Image image = this.getImage(this.getDocumentBase(), name);
        this.m_mediaTracker.addImage(image, 0);
        return image;
    }

    public void update(final Graphics graphics) {
        switch (Fillit.GameFlag) {
            case 0: {
                this.PaintGame(Fillit.MyGfx);
                this.paint(graphics);
                break;
            }
            case 1: {
                this.PaintIntro(Fillit.MyGfx);
                this.paint(graphics);
                break;
            }
        }
        Fillit.updated = true;
    }

    public boolean keyUp(final Event event, final int keyUpCode) {
        if (this.gameover) {
            return false;
        }
        switch (Fillit.KeyUpCode = keyUpCode) {
            case 35: {
                Fillit.Stage = 5L;
                break;
            }
            case 36: {
                Fillit.Stage = 9L;
                break;
            }
            case 50: {
                Fillit.Stage = 10L;
                break;
            }
            case 1006: {
                Fillit.Key_L = false;
                break;
            }
            case 1007: {
                Fillit.Key_R = false;
                break;
            }
            case 1004: {
                Fillit.Key_U = false;
                break;
            }
            case 1005: {
                Fillit.Key_D = false;
                break;
            }
        }
        return true;
    }

    static {
        Fillit.SinusList = new int[450];
        Fillit.oldscore = 0L;
        Fillit.Bobs = new Sprite[32];
    }

    public void InitIntro() {
        Fillit.KeyDownCode = 0;
        Fillit.KeyUpCode = 0;
        Fillit.GameFlag = 1;
    }

    private void PaintIntro(final Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, Fillit.dim.width, Fillit.dim.height);
        graphics.drawString("PaintIntro...", 10, 20);
        graphics.drawImage(Fillit.Title, 120, 40, Color.white, null);
        graphics.setColor(Color.white);
        graphics.drawString("FreeArcade.com Presents", 140, 20);
        graphics.drawString("copyright 1999 by Burkhard Ratheiser", 120, 150);
        graphics.setColor(Color.yellow);
        graphics.drawString("Score:    " + Fillit.Score, 180, 190);
        graphics.drawString("HiScore: " + Fillit.HiScore, 180, 210);
        graphics.setColor(Color.green);
        graphics.drawString("press Space to start", 162, 260);
        this.again.hide();
        this.send.hide();
        this.entryName.hide();
        this.alreadysent = false;
        this.gameover = false;
    }

    public void start() {
        if (this.MyThread == null) {
            (this.MyThread = new Thread(this)).start();
        }
    }

    public long GetLastScore() {
        return Fillit.oldscore;
    }

    public String getAppletInfo() {
        return "Name: Fill It!\r\nAuthor: Burkhard Ratheiser\r\ncopyright 1998 Burkhard Ratheiser";
    }

    public boolean action(final Event event, final Object o) {
        if (event.target == this.again) {
            this.again.hide();
            this.send.hide();
            this.entryName.hide();
            Fillit.CompleteCounter = 0;
            Fillit.OverCounter = 0;
            this.InitIntro();
            this.requestFocus();
        }
        else if (event.target == this.send && !this.alreadysent) {
            this.alreadysent = true;
            this.send.hide();
            this.entryName.hide();
            this.repaint();
            if (this.cgi.call("course=" + "Fillit" + "&name=" + this.entryName.getText().replace('&', '_') + "&time=" + Fillit.Score).equals("OK")) {
                this.send.hide();
                this.entryName.hide();
            }
            else {
                this.send.hide();
                this.entryName.hide();
            }
        }
        return false;
    }

    private Image[] LoadFrames(final String str, final int n) {
        final Image[] array = new Image[n];
        for (int i = 0; i < n; ++i) {
            final int j = i + 1;
            array[i] = this.getImage(this.getDocumentBase(), str + ((j < 10) ? "0" : "") + j + ".gif");
            this.m_mediaTracker.addImage(array[i], 0);
        }
        return array;
    }

    public void run() {
        try {
            this.m_mediaTracker.waitForAll();
            this.requestFocus();
            Fillit.dim = this.size();
            try {
                Fillit.BackBuffer = this.createImage(Fillit.dim.width, Fillit.dim.height);
                Fillit.MyGfx = Fillit.BackBuffer.getGraphics();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("BackBuffer=" + Fillit.BackBuffer);
                System.out.println("MyGfx=" + Fillit.MyGfx);
            }
            try {
                Fillit.RescueBuffer = this.createImage(Fillit.dim.width, Fillit.dim.height);
                Fillit.RescueGfx = Fillit.RescueBuffer.getGraphics();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                System.out.println("RescueBuffer=" + Fillit.RescueBuffer);
                System.out.println("RescueGfx=" + Fillit.RescueGfx);
            }
            Fillit.GameFlag = 1;
            this.repaint();
            while (true) {
                if (Fillit.updated) {
                    Fillit.updated = false;
                    switch (Fillit.GameFlag) {
                        case 0: {
                            this.GameHandler();
                            Thread.sleep(33L);
                            continue;
                        }
                        case 1: {
                            this.repaint();
                            if (Fillit.KeyDownCode == 32) {
                                this.InitGame();
                            }
                            Thread.sleep(33L);
                            continue;
                        }
                    }
                }
                Thread.sleep(500);
            }
        }
        catch (InterruptedException ex3) {
            this.stop();
        }
    }

    public void init() {
        this.requestFocus();
        Fillit.dim = this.size();
        (this.again = new Button("Play Again")).reshape(100, 180, 100, 30);
        this.add(this.again);
        (this.send = new Button("Send Record")).reshape(100, 220, 100, 30);
        this.add(this.send);
        (this.entryName = new TextField(10)).reshape(220, 220, 100, 30);
        this.add(this.entryName);
        this.again.hide();
        this.send.hide();
        this.entryName.hide();
        this.alreadysent = false;
        this.gameover = false;
        this.param = this.getParameter("Scorepath");
        if (this.param != null) {
            this.m_cfgfile = this.param;
        }
        if (this.m_cfgfile != "") {
            this.readcfgFile();
        }
        if (this.URLName == null) {
            this.URLName = "http://www.FreeArcade.com";
        }
        this.URLName += "/cgi-bin/fillit_record.cgi";
        this.cgi = new CGIcall(this.URLName);
        int n = 0;
        do {
            Fillit.SinusList[n] = (int)(Math.sin(n * 2 * 3.141592653589793 / 360.0) * 16384.0);
        } while (++n < 450);
        Sprite.main = this;
        Fillit.Title = this.LoadImage("Title.gif");
        Fillit.Player_Frames = this.LoadFrames("Player", 4);
        Fillit.Enemy_Frames = this.LoadFrames("Enemy", 8);
        Fillit.xsize = Fillit.dim.width;
        Fillit.ysize = Fillit.dim.height - 16;
        Fillit.HiScore = 0L;
        Fillit.Score = 0L;
        this.InitIntro();
        this.requestFocus();
    }

    public boolean GetNewSprite(final Sprite sprite) {
        int n = 0;
        while (Fillit.Bobs[n] != null) {
            if (++n >= 32) {
                return false;
            }
        }
        Fillit.Bobs[n] = sprite;
        return true;
    }

    private void readcfgFile() {
        try {
            final URL url = new URL(this.getCodeBase(), this.m_cfgfile);
            try {
                final DataInputStream dataInputStream = new DataInputStream(url.openStream());
                if (dataInputStream == null) {
                    return;
                }
                final String line = dataInputStream.readLine();
                if (line != null) {
                    this.URLName = line;
                }
            }
            catch (IOException ex) {}
        }
        catch (MalformedURLException ex2) {
            System.err.println("Could not open config file.");
        }
    }
}
